using System;
using System.Collections.Generic;

namespace z3
{
    class Program
    {
        struct Jarbol
        {
            public int X;
            public int Y;
            public Jarbol(int x, int y)
            {
                X = x;
                Y = y;
            }
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            string[] l = Console.ReadLine().Split(" ");
            string[] l1 = Console.ReadLine().Split(" ");
            List<Jarbol> jarboli = new List<Jarbol>();
            List<double> resenja = new List<double>();
            for (int i = 0; i < n; i++)
            {
                jarboli.Add(new Jarbol(int.Parse(l[i]), int.Parse(l1[i])));
            }
            int maxVisina = MaxVis(jarboli);
            int brMax = BrMaxVis(jarboli, maxVisina);
            for (int i = 0; i < n; i++)
            {
                if (i < n - 1)
                {
                    resenja.Add(RacDistancu(jarboli, i));

                }
                else
                {
                    resenja.Add(-1);
                }
            }
            foreach (double r in resenja)
            {
                Console.WriteLine(r);
            }
        }
        static int MaxVis(List<Jarbol> jarboli)
        {
            int Hmax = jarboli[0].Y;
            foreach (Jarbol j in jarboli)
            {
                if (j.Y > Hmax)
                {
                    Hmax = j.Y;
                }
            }
            return Hmax;
        }

        static int BrMaxVis(List<Jarbol> jarboli, int maxH)
        {
            int br = 0;
            foreach (var j in jarboli)
            {
                if (j.Y == maxH)
                {
                    br++;
                }
            }
            return br;
        }
        static double Distanca(double x1, double y1, double x2, double y2)
        {
            return Math.Sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        }
        static double RacDistancu(List<Jarbol> jarboli, int i)
        {
            Jarbol trenutni = jarboli[i];
            Jarbol sledeci = jarboli[i + 1];

            if (sledeci.Y < trenutni.Y)
            {
                double x = ((trenutni.X + sledeci.X) + (trenutni.Y - sledeci.Y)) / 2.0;
                double y = ((trenutni.Y + sledeci.Y - (sledeci.X - trenutni.X))) / 2.0;
                double a = Distanca(x, y, trenutni.X + trenutni.Y - sledeci.Y, sledeci.Y);
                double b = Distanca(x, y, sledeci.X, sledeci.Y);
                return Math.Sqrt(a * a + b * b);
            }
            else
            {
                double x = ((trenutni.X + trenutni.Y) + (sledeci.X - sledeci.Y)) / 2.0;
                double y = trenutni.Y - (x - trenutni.X);
                double a = Distanca(x, y, trenutni.X, trenutni.Y);
                double b = Distanca(x, y, sledeci.X - sledeci.Y + trenutni.Y, trenutni.Y);
                return Math.Sqrt(a * a + b * b);
            }
        }
    }
}